function historical_index = merge_maturities(index_5yr, index_7yr, index_10yr)
% --------------------------------------------------------------------------------------------------
% Merge different maturities of the same index into single object
% --------------------------------------------------------------------------------------------------
% index_5yr  ... structure with historical data on index with 5-year maturity
% index_7yr  ... structure with historical data on index with 7-year maturity
% index_10yr ... structure with historical data on index with 10-year maturity
% --------------------------------------------------------------------------------------------------
% sample call: merge_maturities(IG5Y_index, IG7Y_index, IG10Y_index);
% --------------------------------------------------------------------------------------------------

% Generate structure with historical index and tranche prices
historical_index = struct( ...
      'dates', {{index_5yr.dates index_7yr.dates index_10yr.dates}}, ...
      'T', {{index_5yr.T index_7yr.T index_10yr.T}}, ...
      'cut_offs', {[0.0300 0.0700 0.1000 0.1500 0.3000]}, ...
      'index_market_price', {{index_5yr.index_market_price index_7yr.index_market_price index_10yr.index_market_price}}, ...
      'tranche_market_price_bid', {{index_5yr.tranche_market_price_bid index_7yr.tranche_market_price_bid index_10yr.tranche_market_price_bid}}, ...
      'tranche_market_price_ask', {{index_5yr.tranche_market_price_ask index_7yr.tranche_market_price_ask index_10yr.tranche_market_price_ask}}, ...
      'tranche_market_price_mid', {{index_5yr.tranche_market_price_mid index_7yr.tranche_market_price_mid index_10yr.tranche_market_price_mid}}, ...
      'tranche_market_upfront_bid', {{index_5yr.tranche_market_upfront_bid index_7yr.tranche_market_upfront_bid index_10yr.tranche_market_upfront_bid}}, ...
      'tranche_market_upfront_ask', {{index_5yr.tranche_market_upfront_ask index_7yr.tranche_market_upfront_ask index_10yr.tranche_market_upfront_ask}}, ...
      'tranche_market_upfront_mid', {{index_5yr.tranche_market_upfront_mid index_7yr.tranche_market_upfront_mid index_10yr.tranche_market_upfront_mid}}, ...
      'delta_tr_idx_GC', {{index_5yr.delta_tr_idx_GC index_7yr.delta_tr_idx_GC index_10yr.delta_tr_idx_GC}} ... 
);                      